<?php

/**
 *
 * INDEXU
 * Copyright(C), Nicecoder, 2000-2006, All Rights Reserved.
 *
 * INDEXU(tm) is protected by Indonesia and International copyright laws.
 * Unauthorized use or distribution of INDEXU(tm) is strictly prohibited,
 * violators will be prosecuted. To obtain a license for using INDEXU(tm),
 * please register at Nicecoder home page at http://www.nicecoder.com
 *
 * Author:
 *    Dody Rachmat Wicaksono (dody@nicecoder.com)
 *    M. Zuber (zubby@nicecoder.com)
 *
 */
 
  /*===================================================
    ShowFormSearchUser()
  ===================================================*/

  function ShowFormSearchUser() {
    global $theme_path;

    DisplayTemplate($theme_path . "user_search_form.html");
  }


  /*===================================================
    ProcessFormSearchUser()
  ===================================================*/
  
  function ProcessFormSearchUser() {

    // vars global configuration
    global $theme_path;

    // vars url & form
    global $username, $password, $email, $name, $homepage, $icq, $yahoo, $aol, $biography, $interest, $location,
             $occupation, $pg_which, $ltr, $user_max_rows, $max_rows;

    // vars messages
    global $msg;

    // vars template
    global $user, $pagination, $param, $num_rows;

    $users_obj = new clsUsers;
    $users_obj->table_name    = "idx_users";
    $users_obj->template_file = $theme_path . "user_search_result_rows.html";
    $users_obj->paging        = true;
    $users_obj->date_format   = $msg["10291"];
    $users_obj->pg_size       = ($user_max_rows) ? $user_max_rows : $max_rows;
    $users_obj->href          = "user_search.php";
    $fields                   = $users_obj->GetFields();

    // querying
    $query = "select * from idx_users where 0=0 ";

    $i     = 0;
    
    $count_fields = @count($fields);
    while ($i < $count_fields) {
      $field = $fields[$i];

      if (!empty($$field))
        $query .= "and $field like '%" . $$field . "%' ";

      $i++;
    }

    if ($ltr != "") {
      if ($ltr == "#") {
        $query .= "and username not regexp('^[a-zA-Z]')";
      }
      else {
        $query .= "and username like '$ltr%'";
      }
    }

    $query .= " order by username";

    $users_obj->query      = $query;
    $users_obj->more_param =
      "&pflag=search&username=$username&email=$email&name=$name&homepage=$homepage&icq=$icq&yahoo=$yahoo"
      . "&aol=$aol&biography=$biography&interest=$interest&location=$location&occupation=$occupation"
      . "&ltr=$ltr";
    $user                  = $users_obj->DisplayUsers();
    $pagination            = $users_obj->pagination;
    $num_rows              = $users_obj->num_rows;

    DisplayTemplate($theme_path . "user_search_result.html", "\$user,\$pagination,\$param,\$num_rows");
  }


  /*===================================================
    main
  ===================================================*/

  include "application.php";

  RunPreFilter(__FILE__);

  if (empty($pflag)) {
    ShowFormSearchUser();
  }
  elseif ($pflag == 'search') {
    ProcessFormSearchUser();
  }

  RunPostFilter(__FILE__);

?>